#include "VOS_API/DX_VOS_Memmap.h"


EXPORT_C DxStatus DX_VOS_MemMap(DxUint32_t aPhysicalAddress, DxUint32_t aMapSize, DxUint32_t *aVirtualAddr)
{
	aMapSize = aMapSize;

	DX_ASSERT_PARAM(aVirtualAddr != DX_NULL);

  *aVirtualAddr=aPhysicalAddress;
	DX_RETURN(DX_SUCCESS);
}

EXPORT_C DxStatus DX_VOS_MemUnMap(void *aVirtualAddr, DxUint32_t aMapSize)
{
    DX_ASSERT_PARAM(DX_VALID_PTR_DATA(aVirtualAddr,aMapSize));

	DX_RETURN(DX_SUCCESS);
}

EXPORT_C DxStatus DX_VOS_MemVirtualToPhysical(void *aVirtualAddr, DxUint32_t aMapSize, DX_PhysicalAddr_t *aPhysicalAdrr)
{
    DX_ASSERT_PARAM(aVirtualAddr != DX_NULL);
    DX_ASSERT_PARAM(aMapSize != 0);
    DX_ASSERT_PARAM(aPhysicalAdrr != DX_NULL);

  aPhysicalAdrr->nEntries = 1;
  aPhysicalAdrr->entry_addr[0] = (DxUint32_t*) aVirtualAddr;
  aPhysicalAdrr->entrySize[0] = aMapSize;

    DX_RETURN(DX_SUCCESS);
}
